# DX_CC6_CORE_HOST_SIDE makefile
# CRYS component
#

COMP_NAME := $(CRYS_ID)

#id's of the components this component depends on
$(COMP_NAME)_DEPEND_ON_APIS := $(VOS_ID) $(CC6_GEN_ID)

#paths of this component API include directories
$(COMP_NAME)_API_INCL_PATH := \
	$(HOST_PATH)DX_CRYS_API/$(CRYS_API_PATH)inc/ \
	$(HOST_PATH)DX_CRYS_API/$(CRYS_API_PATH)tinc/ \
	$(HOST_PATH)CRYS/tinc/ \
	$(HOST_PATH)DX_CRYS_API/CC6_CRYS_API/inc

#paths of the internal include directories
$(COMP_NAME)_INTERNAL_INCL_PATH := \
	

#global flags for this component
#project-specific flags for this component should be added to $($(COMP_NAME)_SPECIFIC_CCFLAGS) outside of this makefile
$(COMP_NAME)_CCFLAGS := 

#the objects names without path or extension
$(COMP_NAME)_OBJ_NAMES := \
	CRYS_AES CRYS_HASH CRYS_DES CRYS_HMAC \
	CRYS_Init CRYS_RC4 CRYS_RND CRYS_RSA_BUILD CRYS_RSA_KG \
	CRYS_RSA_Sign CRYS_RSA_Verify CRYS_RSA_OAEP CRYS_RSA_PRIM CRYS_version \
	CRYS_DH CRYS_SELF_TEST CRYS_ECDH CRYS_ECDSA_Sign CRYS_ECDSA_Verify \
	CRYS_ECPKI_BUILD CRYS_ECPKI_KG CRYS_EC_ELGAMAL CRYS_KDF CRYS_AESCCM 

#Use the above specific settings for building the components properties with the standard rules:
include $(MF_PATH)CC6_STD_RULES.inc

##  OBJECT RULES - ADD RULES FOR NEW SOURCE FILES
#   make sure to add obj_name to the above list: $(COMP_NAME)_OBJS
#   this is the template for rules:
#$(OUT_OBJ_PATH)<<OBJ_NAME>>.$(OBJEXT): $(HOST_PATH)<<SOURCE_PATH>>
#	$(CRYS_CC_CMD) $< $(CCFLAG_OUTPUT) $@


$(OUT_OBJ_PATH)CRYS_AES.$(OBJEXT): $(HOST_PATH)CRYS/src/CRYS_AES.c
	$(CRYS_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_AESCCM.$(OBJEXT): $(HOST_PATH)CRYS/src/CRYS_AESCCM.c
	$(CRYS_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_HASH.$(OBJEXT): $(HOST_PATH)CRYS/src/CRYS_HASH.c
	$(CRYS_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_DES.$(OBJEXT): $(HOST_PATH)CRYS/src/CRYS_DES.c
	$(CRYS_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_HMAC.$(OBJEXT): $(HOST_PATH)CRYS/src/CRYS_HMAC.c
	$(CRYS_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_Init.$(OBJEXT): $(HOST_PATH)CRYS/src/CRYS_Init.c
	$(CRYS_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_RC4.$(OBJEXT): $(HOST_PATH)CRYS/src/CRYS_RC4.c
	$(CRYS_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_RND.$(OBJEXT): $(HOST_PATH)CRYS/src/CRYS_RND.c
	$(CRYS_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_RSA_BUILD.$(OBJEXT): $(HOST_PATH)CRYS/src/CRYS_RSA_BUILD.c
	$(CRYS_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_RSA_KG.$(OBJEXT): $(HOST_PATH)CRYS/src/CRYS_RSA_KG.c
	$(CRYS_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_RSA_Sign.$(OBJEXT): $(HOST_PATH)CRYS/src/CRYS_RSA_Sign.c
	$(CRYS_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_RSA_Verify.$(OBJEXT): $(HOST_PATH)CRYS/src/CRYS_RSA_Verify.c
	$(CRYS_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_RSA_OAEP.$(OBJEXT): $(HOST_PATH)CRYS/src/CRYS_RSA_OAEP.c
	$(CRYS_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_RSA_PRIM.$(OBJEXT): $(HOST_PATH)CRYS/src/CRYS_RSA_PRIM.c
	$(CRYS_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_version.$(OBJEXT): $(HOST_PATH)CRYS/src/CRYS_version.c
	$(CRYS_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_DH.$(OBJEXT): $(HOST_PATH)CRYS/src/CRYS_DH.c
	$(CRYS_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_SELF_TEST.$(OBJEXT): $(HOST_PATH)CRYS/src/CRYS_SELF_TEST.c
	$(CRYS_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ECDH.$(OBJEXT): $(HOST_PATH)CRYS/src/CRYS_ECDH.c
	$(CRYS_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ECDSA_Sign.$(OBJEXT): $(HOST_PATH)CRYS/src/CRYS_ECDSA_Sign.c
	$(CRYS_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ECDSA_Verify.$(OBJEXT): $(HOST_PATH)CRYS/src/CRYS_ECDSA_Verify.c
	$(CRYS_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ECPKI_BUILD.$(OBJEXT): $(HOST_PATH)CRYS/src/CRYS_ECPKI_BUILD.c
	$(CRYS_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ECPKI_KG.$(OBJEXT): $(HOST_PATH)CRYS/src/CRYS_ECPKI_KG.c
	$(CRYS_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_EC_ELGAMAL.$(OBJEXT): $(HOST_PATH)CRYS/src/CRYS_EC_ELGAMAL.c
	$(CRYS_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_KDF.$(OBJEXT): $(HOST_PATH)CRYS/src/CRYS_KDF.c
	$(CRYS_CC_CMD) $< $(CCFLAG_OUTPUT) $@


